
#include    "string.h"
#include    "main.h"
#include	"lcm.h"
#include	"led.h"
#include	"timer.h"
#include	"button.h"
#include	"keelog.h"

uc8	ver1_str[]= "Hopping";
uc8	ver2_str[]= "CodeKit";
uc8	ver3_str[]= "BC2502 ";
uc8	ver4_str[]= "Ver 12 ";
uc8	ver5_str[]= "20211118";

uc8	hoppingcode_1_Str[] = "HoppingCode-Kit";
uc8 hoppingcode_2_Str[] = "TXATXB Paired NN";
uc8 hoppingcode_M_Str[] = "Manufacturer:   ";
uc8 hoppingcode_3_Str[] = "NLF:            ";
uc8 hoppingcode_5_Str[] = "Packet:         ";
uc8 hoppingcode_6_Str[] = "Type:           ";

#if PACKET_TYPE==1	
uc8 hoppingcode_p_Str[] = "Standard        "; 	
#else
uc8 hoppingcode_p_Str[] = "HT Enhance      "; 	   	
#endif	

#if Hopping_type==0	
uc8 hoppingcode_T_Str[] = "Simple          "; 	
#else
uc8 hoppingcode_T_Str[] = "Normal          "; 	   	
#endif	

uc8 hoppingcode_3_En_Str[] = "En.Data:        ";
uc8 hoppingcode_3_De_Str[] = "De.Data:        ";
uc8 hoppingcode_4_Str[] = "----------------";
uc8	hoppingcode_8_Str[] = "TXA ReSync FAIL ";
uc8	hoppingcode_9_Str[] = "TXB ReSync FAIL ";
uc8	hoppingcode_10_Str[] = "TXA ReSync PASS ";
uc8	hoppingcode_11_Str[] = "TXB ReSync PASS ";
uc8	hoppingcode_12_Str[] = "TXA Blocked Win ";
uc8	hoppingcode_13_Str[] = "TXB Blocked Win ";
uc8 hoppingcode_3_F_Str[] = "--------";

uc8 hoppingcode_30_Str[] = "En/Decrypted Key";
uc8	hoppingcode_31_Str[] = "TXA paired OK!! ";
uc8	hoppingcode_32_Str[] = "TXB Paired OK!! ";
uc8	hoppingcode_33_Str[] = "TXA pairing !!  ";
uc8	hoppingcode_34_Str[] = "TXB pairing !!  ";
uc8	hoppingcode_35_Str[] = "TXA pair timeout";
uc8	hoppingcode_36_Str[] = "TXB pair timeout";
uc8 hoppingcode_40_Str[] = "ALL pair delete!";

uc8	hoppingcode_50_Str[] = "SN       SC     ";
uc8	hoppingcode_51_Str[] = "SN:             ";
uc8	hoppingcode_52_Str[] = "SC:             ";
uc8	hoppingcode_60_Str[] = "Repeat:   VLow: ";

uc8	UpString[] = "Up";
uc8	DnString[] = "Dn";
uc8	YesString[] = "Y";
uc8	NoString[] = "N";

uc8	hoppingcode_70_Str[] = "TXA:recived ";
uc8	hoppingcode_71_Str[] = "TXB:recived ";

bit	timer1ms,timer2ms,timer10ms;
bit	button_change;
bit	SystemSleep;
bit RX_Window_Flag;

uint8		key_status;
uint8		time_period;
//=======0710==========
unsigned char mRFSNA[5];
unsigned char mRFSN_T[4];
unsigned char mRFSNB[5];
uint8      count =0;
uint16      RX_Window_Cnt = 0;
uint8      mLedCnt ;
uint8      mTmCnt[2];
uint8      mReSyncCnt;
uint8      mRxData;
uint32     data_temp;
uint8      key_temp[4];
uint8	   fPairingACursor;
uint8      fPairingBCursor;
uint8      Sync_Counter[2];
uint8      Sync_Counter_T[2];
uint16     SyncCount_A;
uint16     SyncCount_A_T;
uint16     SyncCount_A_rs;
uint16     SyncCount_B;
uint16     SyncCount_B_T;
uint16     SyncCount_B_rs;
uint8	   fLearnedACursor;
uint8      fLearnedBCursor;
uint32     SN_A;
uint8      SyncConter10[5];

uint8      CRC_8BIT,CRC_4BIT;

extern unsigned char  mRFData[9];
static volatile uint8 TxPayloadData[16] __attribute__ ((at(0x0E0)));

//subroutine
void EEPROM_WR(unsigned char GU8V_EEPROM_ADDR,unsigned char GU8V_WR_DATA);
unsigned char EEPROM_RD(unsigned char GU8V_EEPROM_ADDR);
void GetRFSN();
void IsValidSN();
void CheckRFSN();
void Init_I2C();
void Init_RxTM();
void RX_On();
void RX_Off();
void RX_Window(void);
void Process_RF_packet();
void StartPairing();
void DeletePaired();
void RunRFdata();
void CheckRFAddr();
void CheckLEDtimeout();
void CheckReSynctimeout();
void CheckPairingTimeOut();
void LCMdisplay_encryptedData();
void Display_TXA_Info();
void Display_TXB_Info();
void Display_Manufacturercode();
void Display_NLF();
void KeeloqKey_Generation();
void GetEnDeKey();
void Save_TXA_SN_SC_KEY();
void Save_TXB_SN_SC_KEY();

void RF_Configuration();

void Display_EnDecrypted_Key();

//FLAG
byte_t FLAG1,RF_Flag;
#define fLearnedA 	FLAG1.bits.b0
#define fLearnedB 	FLAG1.bits.b1
#define fPairingA	FLAG1.bits.b2
#define fPairingB	FLAG1.bits.b3
#define f8ms		FLAG1.bits.b4	// set by TB0 ISR
#define fRFSNOk		FLAG1.bits.b5

#define fReceived	RF_Flag.bits.b0
#define fDataok		RF_Flag.bits.b1
#define fRxBusy		RF_Flag.bits.b2
#define fLearnedA_R RF_Flag.bits.b3
#define fLearnedB_R RF_Flag.bits.b4

// WDT
#define DIS_WDT()		{_wdtc=0xaf;}
#define	WDT_8ms		0
#define	WDT_32ms	1
#define	WDT_125ms	2	
#define	WDT_500ms	3
#define	WDT_1s 		4
#define	WDT_2s		5
#define	WDT_4s		6
#define	WDT_8s		7
#define WDT_TM  WDT_2s
#define EN_WDT()	 {_wdtc=0x50+WDT_TM;}

// LED
#define LED1_ON()    { LED1O = 0;}
#define LED2_ON()    { LED2O = 0;}
#define LED3_ON()    { LED3O = 0;}
#define LED4_ON()    { LED4O = 0;}
#define LED1_OFF()   { LED1O = 1;}
#define LED2_OFF()   { LED2O = 1;}
#define LED3_OFF()   { LED3O = 1;}
#define LED4_OFF()   { LED4O = 1;}
#define LED_OFF()    { LED1O = 1;LED2O = 1;LED3O = 1;LED4O = 1;}

#define LED_TIMEOUT 50
#define RESYNC_TIMEOUT 63

// STM Enable
#define RFTimerOn()  {_st0on=1;}		           
#define RFTimerOff() {_st0on=0;}	

// Keeloq
extern volatile	uint8	EncryptionKey[8];
extern volatile	uint8	Ciphertext[4];

const uint8 __attribute__((at(0x1FF0))) MANUFACTURE[8] = { MANUFACTURE_BUFF0,MANUFACTURE_BUFF1,MANUFACTURE_BUFF2,MANUFACTURE_BUFF3,MANUFACTURE_BUFF4,MANUFACTURE_BUFF5,
															MANUFACTURE_BUFF6,MANUFACTURE_BUFF7 };
/*---------------------------------------------------------------------------*/
/*   */
/*---------------------------------------------------------------------------*/
uint8 BinToChar(uint8 bn)
{
	if(bn >= 10)
	{
		bn += ('A' - 10);
	}
	else
	{
		bn += '0';
	}
	return(bn);
}
/*---------------------------------------------------------------------------*/
/*   */
/*---------------------------------------------------------------------------*/
void main(void)
{  
	uint8	x;
	  
   if((_pdf == TRUE) && (_to == TRUE)) goto WakeUpBegin;
	SystemClock_Configure();
	LCM_InterfaceConfigure();
	LCM_Initialize();
	LED_InterfaceConfigure();
	BTN_InterfaceConfigure();

	LCM_BCLogo();
	LCM_ConstString8(ver1_str,2,9,DSP_NORMAL);
	LCM_ConstString8(ver2_str,3,9,DSP_NORMAL);
	LCM_ConstString8(ver3_str,4,9,DSP_NORMAL);
	LCM_ConstString8(ver4_str,5,9,DSP_NORMAL);
	LCM_ConstString8(ver5_str,6,8,DSP_NORMAL);	
	for(x=0;x<20;x++) DelayXmSec(50*T1MS);					/*delay 1S */
	LCM_Clear();
	LCM_ConstString8(hoppingcode_1_Str,0,0,DSP_NORMAL);
	LCM_ConstString8(hoppingcode_2_Str,1,0,DSP_NORMAL);
	LCM_ConstString8(hoppingcode_M_Str,2,0,DSP_NORMAL);
	LCM_ConstString8(hoppingcode_4_Str,3,0,DSP_NORMAL);
	LCM_ConstString8(hoppingcode_3_Str,4,0,DSP_NORMAL);
	LCM_ConstString8(hoppingcode_5_Str,5,0,DSP_NORMAL);
	LCM_ConstString8(hoppingcode_p_Str,5,7,DSP_NORMAL);
	LCM_ConstString8(hoppingcode_6_Str,6,0,DSP_NORMAL);
	LCM_ConstString8(hoppingcode_T_Str,6,5,DSP_NORMAL);
	

	
	GetRFSN();							    // read pairing Serial Number from EEprom
	IsValidSN();							// check pairing Serial Number, if vaild --> fLearned = 1
	EN_WDT();	

	RF_Configuration();						//RF configuration

	Init_RxTM();							// initialize Rx Time Module				
			
	RX_On();
	RFTimerOn();
	timebase0_configure();
	timebase1_configure();
	SystemSleep = FALSE;
    Display_Manufacturercode();
    Display_NLF();
    LED_AlwaysOn(LEDP);
    _emi = TRUE;
    
    
    RFTimerOn();
	RX_Window_Flag =1 ;
MainLoop:
	while(SystemSleep == FALSE)
	{
		GCC_CLRWDT();
		if(timer2ms)
		{
			timer2ms = FALSE;
		//	RX_Window();			
			button_change = BTN_ScanStatus();
			LED_FlashProcess();
			if(time_period != 0) time_period--;
		}
		if(button_change)
		{
			button_change = FALSE;
			key_status = BTN_GetStatus();
		}
		
		if(fReceived)						// RF packet received 
		{
			RFTimerOff();
			fReceived=0;
 			LCMdisplay_encryptedData();	
 			if(fPairingA | fPairingB)
    			//=====Keeloq Key Generation
  				KeeloqKey_Generation();					
 			
 			if(fLearnedA |fLearnedB)
 				GetEnDeKey();
 				
			//clear LCM 
			if((mRFData[0] & 0x02) ==0x00 )
			{
				LCM_LineClear(4);			
				LCM_LineClear(5);
			    LCM_LineClear(6);
			}	
			LCM_LineClear(7);			
			LCM_ConstString8(hoppingcode_3_F_Str,3,8,DSP_NORMAL); 		
		
 			if(fPairingA | fPairingB | fLearnedA_R | fLearnedB_R)	
 			{
				//decryption
				data_temp =0;
				data_temp |= (uint32)mRFData[5] <<24;
				data_temp |= (uint32)mRFData[6] <<16;
				data_temp |= (uint32)mRFData[7] <<8;
				data_temp |= (uint32)mRFData[8] ;			
				KeeloqDecrypt(data_temp); 
				
   				CheckRFSN();				// if fPairing=1 --> check Data Serial Number whether is paired 
   			                                // if fLearned=1 --> compare Data Serial Number with Serial Number saved in eeprom                                  
				if(fDataok & fRFSNOk) 
					RunRFdata();			// Yes, run data   		
 			}
 					                                           
			RFTimerOn();
		}			
		
		if(f8ms)							// 8ms time base is used for key de-bounce and on-off LED 
		{
			f8ms=0;
			if(mLedCnt) 
				CheckLEDtimeout();         //timeout 160us
			if(mReSyncCnt)                  
			    CheckReSynctimeout();      //timeout 500ms
			if(fPairingA || fPairingB) 
				CheckPairingTimeOut();
			if((!KEY1_IN) || (!KEY2_IN) || (!KEY3_IN) ) //KEY1 for pairA / KEY2 for pairB /KEY3 delete pairA/pairB 
			{
				count++;				  // if KEY1/KEY2/KEY3 is pressed 
				if(count==125)			  // KEY1/KEY2/KEY3 is held down > 8x120= 1000ms
				{
				    if((!KEY1_IN) || (!KEY2_IN))
					  StartPairing();
					else if(!KEY3_IN)
					  DeletePaired();
				}		
			}
			else count=0;			   
		}				
	}				
WakeUpBegin:      
   goto  MainLoop;
}


void RF_Configuration()
{
	I2C_Init(); 			
	Entry_I2C_mode();		
	NPH_RX_Init();			
	Exit_I2C_mode();		
	RX_Off();			
}
/*---------------------------------------------------------------------------*/
/*	 */
/*---------------------------------------------------------------------------*/
void SystemClock_Configure()
{   
   _wdtc = 0x57;	
//	_pbs1 |= 0xFC;				/* PB5=RESET,PB6=OSC1,PB7=OSC2 */
//	_pfs1 |= 0x0F;				/* PF4=XT2,PF5=XT1 */
	_rstc = 0xAA;				/* PB5 to RESET PIN */
	_hirc0 = LOW;	
	_hirc1 = LOW;
//	_hxten = LOW;				/* HXT enable */
//	_lxten = HIGH;				/* LXT enable */
//	while(!_lxtf);				/* wait LXT stable */
//	while(!_hxtf);				/* wait HXT stable */	
	/* High Frequency clock = HXT (FHS=1) */	
	/* Low Frequency clock = LXT (FSS=1)*/
	/* High Frequency oscillator control enable(FHIDEN=1) */
	/* Low Frequency oscillator control enable (FSIDEN=1) */
	/* system clock = FH */
#if (SYSTEM_CLOCK == 0)								/* for 4MHZ */
	_scc = 0x2D;				/* system clock = HXT/2 */
	_nop();
	_nop();
	_hircen = LOW;		
#endif	

#if (SYSTEM_CLOCK == 1)								/* for 8MHZ */
	_scc = 0x05;				/* system clock = HXT */
	_nop();
	_nop();		
#endif	

#if (SYSTEM_CLOCK == 2)								/* for 8MHZ */
	_hirc0 = HIGH;	
	_hirc1 = LOW;
	while(!_hircf);
	_scc = 0x05;				/* system clock = HIRC */
	_nop();
	_nop();
	_hxten = LOW;				/* HXT disable */	
#endif
	
}
/*---------------------------------------------------------------------------*/
/********************************************************************
Function: StartPairing
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void StartPairing()
{
	mTmCnt[0]=150;
	mTmCnt[1]=40;
	if(!KEY1_IN)
	{
  	 fPairingA=1;
  	 fPairingB=0;
  	 fPairingACursor =1;
  	 LCM_ConstString8(hoppingcode_33_Str,7,0,DSP_NORMAL);
  	 LED1_ON();
  	 LED2_OFF();
	} 
  	else if(!KEY2_IN)
  	{
  	 fPairingB=1;
  	 fPairingA=0;
  	 fPairingBCursor =1;
  	 LCM_ConstString8(hoppingcode_34_Str,7,0,DSP_NORMAL);
  	 LED1_OFF();
  	 LED2_ON();
  	} 	
}
/********************************************************************
Function: DeletePaired
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void DeletePaired()
{
	uint8 x;
	
	fPairingA=0;
	fLearnedA =0;
	fPairingACursor =0;
	fLearnedACursor =0;
	fPairingB=0;
	fLearnedB =0;
	fPairingBCursor =0;
	fLearnedBCursor =0;
    LED_OFF();
	LED3_ON();
	//SN
	EEPROM_WR(0,0xFF);
	EEPROM_WR(1,0x00);
	EEPROM_WR(2,0xFF);
	EEPROM_WR(3,0x00);
	EEPROM_WR(4,0xFF);	
	EEPROM_WR(5,0xFF);
	EEPROM_WR(6,0x00);
	EEPROM_WR(7,0xFF);
	EEPROM_WR(8,0x00);
	EEPROM_WR(9,0xFF);	
	mRFSNA[0]=0xFF;
	mRFSNA[1]=0x00;
	mRFSNA[2]=0xFF;
	mRFSNA[3]=0x00;
	mRFSNA[4]=0xFF;	
	mRFSNB[0]=0xFF;
	mRFSNB[1]=0x00;
	mRFSNB[2]=0xFF;
	mRFSNB[3]=0x00;
	mRFSNB[4]=0xFF;		
	//Sync Count
	EEPROM_WR(10,0x00);
	EEPROM_WR(11,0xFF);
	EEPROM_WR(12,0x00);
	EEPROM_WR(13,0xFF);	
	Sync_Counter[0] = 0x00;
	Sync_Counter[1] = 0xFF;	
	//Key
	EEPROM_WR(20,0x89);
	EEPROM_WR(21,0x67);
	EEPROM_WR(22,0x45);
	EEPROM_WR(23,0x23);
	EEPROM_WR(24,0x01);	
	EEPROM_WR(25,0xef);
	EEPROM_WR(26,0xcd);
	EEPROM_WR(27,0xab);
	EEPROM_WR(30,0x89);
	EEPROM_WR(31,0x67);
	EEPROM_WR(32,0x45);
	EEPROM_WR(33,0x23);
	EEPROM_WR(34,0x01);	
	EEPROM_WR(35,0xeF);
	EEPROM_WR(36,0xCD);
	EEPROM_WR(37,0xAB);					
	EncryptionKey[0] = 0x89;
	EncryptionKey[1] = 0x67;
	EncryptionKey[2] = 0x45;
	EncryptionKey[3] = 0x23;
 	EncryptionKey[4] = 0x01;
	EncryptionKey[5] = 0xEF;
	EncryptionKey[6] = 0xCD;
	EncryptionKey[7] = 0xAB;
	
	LCM_LineClear(4);			
	LCM_LineClear(5);			
	LCM_LineClear(6);
	
	LCM_ConstString8(NoString,1,14,DSP_NORMAL);
	LCM_ConstString8(NoString,1,15,DSP_NORMAL);
	LCM_ConstString8(hoppingcode_40_Str,7,0,DSP_NORMAL);
	for(x=0;x<2;x++) DelayXmSec(50*T1MS);					/*delay 0.5S */
	LED3_OFF();
	for(x=0;x<2;x++) DelayXmSec(50*T1MS);					/*delay 0.5S */
	LED3_ON();
	for(x=0;x<2;x++) DelayXmSec(50*T1MS);					/*delay 0.5S */
	LED3_OFF();
}			
//;-----------------------------------------------------------------------------;
void CheckPairingTimeOut()
{	
	mTmCnt[0]--;
	if(!mTmCnt[0]) 
	{
		mTmCnt[0]=150;
		mTmCnt[1]--;
		if(!mTmCnt[1])
		{
			if(fPairingA)
			{
			  fPairingA=0;
			  fPairingACursor =0;
			  LCM_ConstString8(hoppingcode_35_Str,7,0,DSP_NORMAL);
			  LED1_OFF();		
			}
			else if(fPairingB)
			{
			  fPairingB=0;
			  fPairingBCursor =0;
			  LCM_ConstString8(hoppingcode_36_Str,7,0,DSP_NORMAL);
			  LED2_OFF();
			}			
		}
		else
		{
			if(mTmCnt[1]&0x01)
			{
				if(fPairingA)
				{
				 LED1_OFF();
				 LED2_OFF();
				} 
				else if(fPairingB)
				{
				 LED2_OFF();	
				 LED1_OFF();
				} 
			}   
			else
			{
				if(fPairingA)
				{
				 LED1_ON();
				 LED2_OFF();
				} 
				else if(fPairingB)
				{
				 LED2_ON();	
				 LED1_OFF();
				} 
			}
		}
	}
}						
//;-----------------------------------------------------------------------------;
void RunRFdata()
{
//display Button Status
#if PACKET_TYPE == 0      //0:HT_enhanced  1:Standard

	if(Ciphertext[3] &0x01)	{LED4_ON();}
	if(Ciphertext[3] &0x02)	{LED3_ON();}
	if(Ciphertext[3] &0x04)	{LED2_ON();}
	if(Ciphertext[3] &0x08)	{LED1_ON();}
#else
	if(mRFData[1]&0x10)	{LED4_ON();}
	if(mRFData[1]&0x20)	{LED3_ON();}
	if(mRFData[1]&0x40)	{LED2_ON();}
	if(mRFData[1]&0x80)	{LED1_ON();}
#endif

	TxPayloadData[0] = BinToChar(Ciphertext[3] >> 4);
	TxPayloadData[1] = BinToChar(Ciphertext[3] & 0x0F);
	TxPayloadData[2] = BinToChar(Ciphertext[2] >> 4);
	TxPayloadData[3] = BinToChar(Ciphertext[2] & 0x0F);
	TxPayloadData[4] = BinToChar(Ciphertext[1] >> 4);
	TxPayloadData[5] = BinToChar(Ciphertext[1] & 0x0F);
	TxPayloadData[6] = BinToChar(Ciphertext[0] >> 4);
	TxPayloadData[7] = BinToChar(Ciphertext[0] & 0x0F);		
	TxPayloadData[8] = 0; 
	LCM_PutString8(TxPayloadData,3,8,DSP_NORMAL);
	
	mLedCnt=LED_TIMEOUT;
		
}			
//;-----------------------------------------------------------------------------;
void CheckLEDtimeout()
{
	mLedCnt--;
	if(!mLedCnt)
		LED_OFF();                                          
}													
//;-----------------------------------------------------------------------------;
//;-----------------------------------------------------------------------------;
void CheckReSynctimeout()
{
	mReSyncCnt--;
	if(!mReSyncCnt)
	{   	       
		if(fLearnedACursor ==1)
		{
			LCM_ConstString8(hoppingcode_8_Str,7,0,DSP_NORMAL);	
			fLearnedACursor =0;
		}						                                
		if(fLearnedBCursor ==1)
		{
			LCM_ConstString8(hoppingcode_9_Str,7,0,DSP_NORMAL);	
			fLearnedBCursor =0;
		}		 
	}
}													
//;-----------------------------------------------------------------------------;
/********************************************************************
Function: GetRFSN
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void GetRFSN()
{
	mRFSNA[0]=EEPROM_RD(0);
	mRFSNA[1]=EEPROM_RD(1);
	mRFSNA[2]=EEPROM_RD(2);
	mRFSNA[3]=EEPROM_RD(3);
	mRFSNA[4]=EEPROM_RD(4);	

	mRFSNB[0]=EEPROM_RD(5);
	mRFSNB[1]=EEPROM_RD(6);
	mRFSNB[2]=EEPROM_RD(7);
	mRFSNB[3]=EEPROM_RD(8);
	mRFSNB[4]=EEPROM_RD(9);		
} 
/********************************************************************
Function: CheckRFSN
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void CheckRFSN()
{
	fRFSNOk=0;
	fDataok =0;
	fLearnedA_R =fLearnedB_R = 0; 
#if PACKET_TYPE==0	
	CRC_8BIT=Serial_CRC();
	CRC_4BIT=Encryp_CRC();
	if(CRC_8BIT==Ciphertext[2] && CRC_4BIT==((mRFData[1]>>4)&0x0f))
	{
		if(fPairingA)
		{
			
			switch(fPairingACursor)
			{
				case 1:
			    if((mRFSNA[0]==(0x0F & mRFData[1]))&&(mRFSNA[1]==mRFData[2])
			    &&(mRFSNA[2]==mRFData[3])&&(mRFSNA[3]==mRFData[4]))
			    {	
					mTmCnt[1] = 1;		
			    }
			    else
			    {
					fPairingACursor =2;	
					mRFSN_T[0] = (mRFData[1] & 0x0F );
			      	mRFSN_T[1] = mRFData[2];
					mRFSN_T[2] = mRFData[3];
			      	mRFSN_T[3] = mRFData[4];
			      	Sync_Counter_T[0] =Ciphertext[0];
			      	Sync_Counter_T[1] =Ciphertext[1];
			    } 
			    break;
			
				case 2:
			    if((mRFSN_T[0]==(0x0F & mRFData[1]))&&(mRFSN_T[1]==mRFData[2])
			    &&(mRFSN_T[2]==mRFData[3])&&(mRFSN_T[3]==mRFData[4])&&(Ciphertext[0] ==(Sync_Counter_T[0]+1)))
			    {
			    	//====SAVE TXA SN/SC/KEY 
			    	Save_TXA_SN_SC_KEY();
					
	                //display en/decrypted Key
	                Display_EnDecrypted_Key();	
	                			
					LCM_ConstString8(hoppingcode_31_Str,7,0,DSP_NORMAL);		   		
			   		LCM_ConstString8(YesString,1,14,DSP_NORMAL);
			   		
			   		fPairingA =0;
			  		fLearnedA=1;
			   		fRFSNOk =1;		   			
			    }
			    else
			    {	
			    	if((mRFData[0] & 0x02) ==0 )	
			        	fPairingACursor =1;
			    	else	
			    		fPairingACursor =2;
			    }	 	
			  	break;
			}	
		}
		
		if(fPairingB)
		{
			switch(fPairingBCursor)
			{
				case 1:
			    if((mRFSNB[0]==(0x0F & mRFData[1]))&&(mRFSNB[1]==mRFData[2])
			    &&(mRFSNB[2]==mRFData[3])&&(mRFSNB[3]==mRFData[4]))
			    {	
					mTmCnt[1] = 1;		
			    }
			    else
			    {
					fPairingBCursor =2;	
					mRFSN_T[0] = (mRFData[1] & 0x0F );
			      	mRFSN_T[1] = mRFData[2];
					mRFSN_T[2] = mRFData[3];
			      	mRFSN_T[3] = mRFData[4];
			      	Sync_Counter_T[0] =Ciphertext[0];
			      	Sync_Counter_T[1] =Ciphertext[1];
			    } 
			    break;
			
				case 2:
			    if((mRFSN_T[0]==(0x0F & mRFData[1]))&&(mRFSN_T[1]==mRFData[2])
			    &&(mRFSN_T[2]==mRFData[3])&&(mRFSN_T[3]==mRFData[4])&&(Ciphertext[0] ==(Sync_Counter_T[0]+1)))
			    {
			    	//====SAVE TXB SN/SC/KEY           
	                Save_TXB_SN_SC_KEY(); 
	
	                //display en/decrypted Key
	                Display_EnDecrypted_Key();
	                
					LCM_ConstString8(hoppingcode_32_Str,7,0,DSP_NORMAL);						   		
			   		LCM_ConstString8(YesString,1,15,DSP_NORMAL);
			   		
			   		fPairingB =0;
			  		fLearnedB=1;
			   		fRFSNOk =1;		   			
			    }
			    else
			    {
			    	if((mRFData[0] & 0x02) ==0)	
			        	fPairingACursor =1;
			    	else	
			    		fPairingACursor =2;	
			    }			    
			  	break;
			}	
		}
	
	
		if(fLearnedA | fLearnedB)
		{
			if((mRFSNA[0]==(0x0F & mRFData[1]))&&(mRFSNA[1]==mRFData[2])\
			&&(mRFSNA[2]==mRFData[3])&&(mRFSNA[3]==mRFData[4]))
			{		
				//get device A sync count
				Sync_Counter[0] = EEPROM_RD(10);	
			  	Sync_Counter[1] = EEPROM_RD(11);
			  	SyncCount_A =0;
	          	SyncCount_A = Sync_Counter[0];
	          	SyncCount_A |= Sync_Counter[1]<<8;
	
	          	SyncCount_A_T = Ciphertext[0];
	          	SyncCount_A_T |= Ciphertext[1]<<8;        
	          		     		  
				switch(fLearnedACursor)
				{
					case 0:					
					if(((SyncCount_A_T > SyncCount_A) && (SyncCount_A_T <= (SyncCount_A+16))) || (fRFSNOk==1) )
					{					  
						Sync_Counter[0] = Ciphertext[0];
						Sync_Counter[1] = Ciphertext[1];          
						EEPROM_WR(10,Sync_Counter[0]);
						EEPROM_WR(11,Sync_Counter[1]);	
						Display_TXA_Info();
			  			fRFSNOk =1;
			  			fDataok=1;	
			  			LCM_ConstString8(hoppingcode_70_Str,8,0,DSP_NORMAL);
					}
					else if((SyncCount_A_T-SyncCount_A) >=32688)
					{
					    fLearnedACursor =0;	
					    LCM_ConstString8(hoppingcode_12_Str,7,0,DSP_NORMAL);				
					}	
					else
					{
						if((mRFData[0] & 0x02) ==0 )
						{
							fLearnedACursor =1;		
							mReSyncCnt=RESYNC_TIMEOUT;
	          				SyncCount_A_rs = Ciphertext[0];
	          				SyncCount_A_rs |= Ciphertext[1]<<8;
						}	
						else
						{
							if((mRFData[0] & 0x02) ==0x02 )
								LCM_ConstString8(YesString,6,7,DSP_NORMAL);
							if((mRFData[0] & 0x01) ==0x01 )
								LCM_ConstString8(YesString,6,15,DSP_NORMAL);											
			  				fRFSNOk =1;
			  				fDataok=1;	
			  				
			  				LCM_ConstString8(hoppingcode_70_Str,7,0,DSP_NORMAL);
			  										
						}						
					}						
			        break;
			        
					case 1:	
					if(SyncCount_A_T ==(SyncCount_A_rs+1))
					{
						LCM_ConstString8(hoppingcode_10_Str,7,0,DSP_NORMAL);				
						Sync_Counter[0] = Ciphertext[0];
						Sync_Counter[1] = Ciphertext[1];          
						EEPROM_WR(10,Sync_Counter[0]);
						EEPROM_WR(11,Sync_Counter[1]);	
						fLearnedACursor =0;
						
						Display_TXA_Info();
			  			fRFSNOk =1;
			  			fDataok=1;	
			  			LCM_ConstString8(hoppingcode_70_Str,7,0,DSP_NORMAL);				
					}				
			        break;	        
				}
			}	
			
			if((mRFSNB[0]==(0x0F & mRFData[1]))&&(mRFSNB[1]==mRFData[2])\
			&&(mRFSNB[2]==mRFData[3])&&(mRFSNB[3]==mRFData[4]))
			{		
			  //get device B sync count
			  Sync_Counter[0] = EEPROM_RD(12);	
			  Sync_Counter[1] = EEPROM_RD(13);
			  SyncCount_B =0;
	          SyncCount_B = Sync_Counter[0];
	          SyncCount_B |= Sync_Counter[1]<<8;
	          
	          SyncCount_B_T = Ciphertext[0];
	          SyncCount_B_T |= Ciphertext[1]<<8;
	          
				switch(fLearnedBCursor)
				{
					case 0:	
					if(((SyncCount_B_T > SyncCount_B) && (SyncCount_B_T <= (SyncCount_B+16)))|| (fRFSNOk==1) )
					{
						Sync_Counter[0] = Ciphertext[0];
						Sync_Counter[1] = Ciphertext[1];          
						EEPROM_WR(12,Sync_Counter[0]);
						EEPROM_WR(13,Sync_Counter[1]);	
						
						Display_TXB_Info();
			  			fRFSNOk =1;
			  			fDataok=1;	
			  			LCM_ConstString8(hoppingcode_71_Str,7,0,DSP_NORMAL);							
					}	 
					else if((SyncCount_B_T-SyncCount_B) >=32688)
					{
					    fLearnedBCursor =0;	
					    LCM_ConstString8(hoppingcode_13_Str,7,0,DSP_NORMAL);				
					}				
					else
					{				
						if((mRFData[0] & 0x02) ==0 )
						{				
							fLearnedBCursor =1;
							mReSyncCnt=RESYNC_TIMEOUT;	
	          				SyncCount_B_rs = Ciphertext[0];
	          				SyncCount_B_rs |= Ciphertext[1]<<8;					
						}
						else
						{				
							if((mRFData[0] & 0x02) ==0x02 )
								LCM_ConstString8(YesString,6,7,DSP_NORMAL);					
							if((mRFData[0] & 0x01) ==0x01 )
								LCM_ConstString8(YesString,6,15,DSP_NORMAL);							
			  				fRFSNOk =1;
			  				fDataok=1;	
			  				LCM_ConstString8(hoppingcode_71_Str,7,0,DSP_NORMAL);						
						}
					}		
			        break;
			        
					case 1:	
					if(SyncCount_B_T ==(SyncCount_B_rs+1))
					{
						LCM_ConstString8(hoppingcode_11_Str,7,0,DSP_NORMAL);				
						Sync_Counter[0] = Ciphertext[0];
						Sync_Counter[1] = Ciphertext[1];          
						EEPROM_WR(12,Sync_Counter[0]);
						EEPROM_WR(13,Sync_Counter[1]);	
						fLearnedBCursor =0;	
						Display_TXB_Info();
			  			fRFSNOk =1;
			  			fDataok=1;	
			  			LCM_ConstString8(hoppingcode_71_Str,7,0,DSP_NORMAL);				
					}		  
			        break;       
				}			 				  	
			}			
		}
		else
		{
			fRFSNOk=0;
			fDataok =0;
		}
	}	
#else
	
	
	
	if(fPairingA)
	{
		
		switch(fPairingACursor)
		{
			case 1:
		    if((mRFSNA[0]==(0x0F & mRFData[1]))&&(mRFSNA[1]==mRFData[2])
		    &&(mRFSNA[2]==mRFData[3])&&(mRFSNA[3]==mRFData[4]))
		    {	
				mTmCnt[1] = 1;		
		    }
		    else
		    {
				fPairingACursor =2;	
				mRFSN_T[0] = (mRFData[1] & 0x0F );
		      	mRFSN_T[1] = mRFData[2];
				mRFSN_T[2] = mRFData[3];
		      	mRFSN_T[3] = mRFData[4];
		      	Sync_Counter_T[0] =Ciphertext[0];
		      	Sync_Counter_T[1] =Ciphertext[1];
		    } 
		    break;
		
			case 2:
		    if((mRFSN_T[0]==(0x0F & mRFData[1]))&&(mRFSN_T[1]==mRFData[2])
		    &&(mRFSN_T[2]==mRFData[3])&&(mRFSN_T[3]==mRFData[4])&&(Ciphertext[0] ==(Sync_Counter_T[0]+1)))
		    {
		    	//====SAVE TXA SN/SC/KEY 
		    	Save_TXA_SN_SC_KEY();
				
                //display en/decrypted Key
                Display_EnDecrypted_Key();	
                			
				LCM_ConstString8(hoppingcode_31_Str,7,0,DSP_NORMAL);		   		
		   		LCM_ConstString8(YesString,1,14,DSP_NORMAL);
		   		
		   		fPairingA =0;
		  		fLearnedA=1;
		   		fRFSNOk =1;		   			
		    }
		    else
		    {	
		    	if((mRFData[0] & 0x02) ==0 )	
		        	fPairingACursor =1;
		    	else	
		    		fPairingACursor =2;
		    }	 	
		  	break;
		}	
	}
	
	if(fPairingB)
	{
		switch(fPairingBCursor)
		{
			case 1:
		    if((mRFSNB[0]==(0x0F & mRFData[1]))&&(mRFSNB[1]==mRFData[2])
		    &&(mRFSNB[2]==mRFData[3])&&(mRFSNB[3]==mRFData[4]))
		    {	
				mTmCnt[1] = 1;		
		    }
		    else
		    {
				fPairingBCursor =2;	
				mRFSN_T[0] = (mRFData[1] & 0x0F );
		      	mRFSN_T[1] = mRFData[2];
				mRFSN_T[2] = mRFData[3];
		      	mRFSN_T[3] = mRFData[4];
		      	Sync_Counter_T[0] =Ciphertext[0];
		      	Sync_Counter_T[1] =Ciphertext[1];
		    } 
		    break;
		
			case 2:
		    if((mRFSN_T[0]==(0x0F & mRFData[1]))&&(mRFSN_T[1]==mRFData[2])
		    &&(mRFSN_T[2]==mRFData[3])&&(mRFSN_T[3]==mRFData[4])&&(Ciphertext[0] ==(Sync_Counter_T[0]+1)))
		    {
		    	//====SAVE TXB SN/SC/KEY           
                Save_TXB_SN_SC_KEY(); 

                //display en/decrypted Key
                Display_EnDecrypted_Key();
                
				LCM_ConstString8(hoppingcode_32_Str,7,0,DSP_NORMAL);						   		
		   		LCM_ConstString8(YesString,1,15,DSP_NORMAL);
		   		
		   		fPairingB =0;
		  		fLearnedB=1;
		   		fRFSNOk =1;		   			
		    }
		    else
		    {
		    	if((mRFData[0] & 0x02) ==0)	
		        	fPairingACursor =1;
		    	else	
		    		fPairingACursor =2;	
		    }			    
		  	break;
		}	
	}


	if(fLearnedA | fLearnedB)
	{
		if((mRFSNA[0]==(0x0F & mRFData[1]))&&(mRFSNA[1]==mRFData[2])\
		&&(mRFSNA[2]==mRFData[3])&&(mRFSNA[3]==mRFData[4]))
		{		
			//get device A sync count
			Sync_Counter[0] = EEPROM_RD(10);	
		  	Sync_Counter[1] = EEPROM_RD(11);
		  	SyncCount_A =0;
          	SyncCount_A = Sync_Counter[0];
          	SyncCount_A |= Sync_Counter[1]<<8;

          	SyncCount_A_T = Ciphertext[0];
          	SyncCount_A_T |= Ciphertext[1]<<8;        
          		     		  
			switch(fLearnedACursor)
			{
				case 0:					
				if(((SyncCount_A_T > SyncCount_A) && (SyncCount_A_T <= (SyncCount_A+16))) || (fRFSNOk==1) )
				{					  
					Sync_Counter[0] = Ciphertext[0];
					Sync_Counter[1] = Ciphertext[1];          
					EEPROM_WR(10,Sync_Counter[0]);
					EEPROM_WR(11,Sync_Counter[1]);	
					Display_TXA_Info();
		  			fRFSNOk =1;
		  			fDataok=1;	
		  			LCM_ConstString8(hoppingcode_70_Str,8,0,DSP_NORMAL);
				}
				else if((SyncCount_A_T-SyncCount_A) >=32688)
				{
				    fLearnedACursor =0;	
				    LCM_ConstString8(hoppingcode_12_Str,7,0,DSP_NORMAL);				
				}	
				else
				{
					if((mRFData[0] & 0x02) ==0 )
					{
						fLearnedACursor =1;		
						mReSyncCnt=RESYNC_TIMEOUT;
          				SyncCount_A_rs = Ciphertext[0];
          				SyncCount_A_rs |= Ciphertext[1]<<8;
					}	
					else
					{
						if((mRFData[0] & 0x02) ==0x02 )
							LCM_ConstString8(YesString,6,7,DSP_NORMAL);
						if((mRFData[0] & 0x01) ==0x01 )
							LCM_ConstString8(YesString,6,15,DSP_NORMAL);											
		  				fRFSNOk =1;
		  				fDataok=1;	
		  				
		  				LCM_ConstString8(hoppingcode_70_Str,7,0,DSP_NORMAL);
		  										
					}						
				}						
		        break;
		        
				case 1:	
				if(SyncCount_A_T ==(SyncCount_A_rs+1))
				{
					LCM_ConstString8(hoppingcode_10_Str,7,0,DSP_NORMAL);				
					Sync_Counter[0] = Ciphertext[0];
					Sync_Counter[1] = Ciphertext[1];          
					EEPROM_WR(10,Sync_Counter[0]);
					EEPROM_WR(11,Sync_Counter[1]);	
					fLearnedACursor =0;
					
					Display_TXA_Info();
		  			fRFSNOk =1;
		  			fDataok=1;	
		  			LCM_ConstString8(hoppingcode_70_Str,7,0,DSP_NORMAL);				
				}				
		        break;	        
			}
		}	
		
		if((mRFSNB[0]==(0x0F & mRFData[1]))&&(mRFSNB[1]==mRFData[2])\
		&&(mRFSNB[2]==mRFData[3])&&(mRFSNB[3]==mRFData[4]))
		{		
		  //get device B sync count
		  Sync_Counter[0] = EEPROM_RD(12);	
		  Sync_Counter[1] = EEPROM_RD(13);
		  SyncCount_B =0;
          SyncCount_B = Sync_Counter[0];
          SyncCount_B |= Sync_Counter[1]<<8;
          
          SyncCount_B_T = Ciphertext[0];
          SyncCount_B_T |= Ciphertext[1]<<8;
          
			switch(fLearnedBCursor)
			{
				case 0:	
				if(((SyncCount_B_T > SyncCount_B) && (SyncCount_B_T <= (SyncCount_B+16)))|| (fRFSNOk==1) )
				{
					Sync_Counter[0] = Ciphertext[0];
					Sync_Counter[1] = Ciphertext[1];          
					EEPROM_WR(12,Sync_Counter[0]);
					EEPROM_WR(13,Sync_Counter[1]);	
					
					Display_TXB_Info();
		  			fRFSNOk =1;
		  			fDataok=1;	
		  			LCM_ConstString8(hoppingcode_71_Str,7,0,DSP_NORMAL);							
				}	 
				else if((SyncCount_B_T-SyncCount_B) >=32688)
				{
				    fLearnedBCursor =0;	
				    LCM_ConstString8(hoppingcode_13_Str,7,0,DSP_NORMAL);				
				}				
				else
				{				
					if((mRFData[0] & 0x02) ==0 )
					{				
						fLearnedBCursor =1;
						mReSyncCnt=RESYNC_TIMEOUT;	
          				SyncCount_B_rs = Ciphertext[0];
          				SyncCount_B_rs |= Ciphertext[1]<<8;					
					}
					else
					{				
						if((mRFData[0] & 0x02) ==0x02 )
							LCM_ConstString8(YesString,6,7,DSP_NORMAL);					
						if((mRFData[0] & 0x01) ==0x01 )
							LCM_ConstString8(YesString,6,15,DSP_NORMAL);							
		  				fRFSNOk =1;
		  				fDataok=1;	
		  				LCM_ConstString8(hoppingcode_71_Str,7,0,DSP_NORMAL);						
					}
				}		
		        break;
		        
				case 1:	
				if(SyncCount_B_T ==(SyncCount_B_rs+1))
				{
					LCM_ConstString8(hoppingcode_11_Str,7,0,DSP_NORMAL);				
					Sync_Counter[0] = Ciphertext[0];
					Sync_Counter[1] = Ciphertext[1];          
					EEPROM_WR(12,Sync_Counter[0]);
					EEPROM_WR(13,Sync_Counter[1]);	
					fLearnedBCursor =0;	
					Display_TXB_Info();
		  			fRFSNOk =1;
		  			fDataok=1;	
		  			LCM_ConstString8(hoppingcode_71_Str,7,0,DSP_NORMAL);				
				}		  
		        break;       
			}			 				  	
		}			
	}
	else
	{
		fRFSNOk=0;
		fDataok =0;
	}
#endif	
}

/********************************************************************
Function: IsValidSN
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void IsValidSN()
{
	unsigned char i;
	
	i=mRFSNA[0]^mRFSNA[1]^mRFSNA[2]^mRFSNA[3];
	if(i==mRFSNA[4])
	{	fLearnedA=1; 	
	    LCM_ConstString8(YesString,1,14,DSP_NORMAL);
	}
	
	i=mRFSNB[0]^mRFSNB[1]^mRFSNB[2]^mRFSNB[3];
	if(i==mRFSNB[4])
	{	fLearnedB=1; 
	    LCM_ConstString8(YesString,1,15,DSP_NORMAL);
	}		
}
/********************************************************************
Function: Display_Manufacturercode
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void Display_Manufacturercode()
{

   	EncryptionKey[0] = (uint8)MANUFACTURE[0];
	EncryptionKey[1] = (uint8)MANUFACTURE[1];
	EncryptionKey[2] = (uint8)MANUFACTURE[2];
	EncryptionKey[3] = (uint8)MANUFACTURE[3];
	EncryptionKey[4] = (uint8)MANUFACTURE[4];
	EncryptionKey[5] = (uint8)MANUFACTURE[5];
	EncryptionKey[6] = (uint8)MANUFACTURE[6];
	EncryptionKey[7] = (uint8)MANUFACTURE[7]; 
	
	
	TxPayloadData[0] = BinToChar(EncryptionKey[7] >> 4);
	TxPayloadData[1] = BinToChar(EncryptionKey[7] & 0x0F);
	TxPayloadData[2] = BinToChar(EncryptionKey[6] >> 4);
   	TxPayloadData[3] = BinToChar(EncryptionKey[6] & 0x0F);
   	TxPayloadData[4] = BinToChar(EncryptionKey[5] >> 4);
   	TxPayloadData[5] = BinToChar(EncryptionKey[5] & 0x0F);
	TxPayloadData[6] = BinToChar(EncryptionKey[4] >> 4);
	TxPayloadData[7] = BinToChar(EncryptionKey[4] & 0x0F);
	TxPayloadData[8] = 0;
   
	LCM_PutString8(TxPayloadData,3,0,DSP_NORMAL);

   	TxPayloadData[0] = BinToChar(EncryptionKey[3] >> 4);
   	TxPayloadData[1] = BinToChar(EncryptionKey[3] & 0x0F);
   	TxPayloadData[2] = BinToChar(EncryptionKey[2] >> 4);
   	TxPayloadData[3] = BinToChar(EncryptionKey[2] & 0x0F);
   	TxPayloadData[4] = BinToChar(EncryptionKey[1] >> 4);
   	TxPayloadData[5] = BinToChar(EncryptionKey[1] & 0x0F);
   	TxPayloadData[6] = BinToChar(EncryptionKey[0] >> 4);
   	TxPayloadData[7] = BinToChar(EncryptionKey[0] & 0x0F);
   	TxPayloadData[8] = 0;
      
   	LCM_PutString8(TxPayloadData,3,8,DSP_NORMAL);
}
/********************************************************************
Function: Display_NLF
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void Display_NLF()
{

   	EncryptionKey[0] = (uint8)NLF_V1;
	EncryptionKey[1] = (uint8)NLF_V2;
	EncryptionKey[2] = (uint8)NLF_V3;
	EncryptionKey[3] = (uint8)NLF_V4;	

   	TxPayloadData[0] = BinToChar(EncryptionKey[0] >> 4);
   	TxPayloadData[1] = BinToChar(EncryptionKey[0] & 0x0F);
   	TxPayloadData[2] = BinToChar(EncryptionKey[1] >> 4);
   	TxPayloadData[3] = BinToChar(EncryptionKey[1] & 0x0F);
   	TxPayloadData[4] = BinToChar(EncryptionKey[2] >> 4);
   	TxPayloadData[5] = BinToChar(EncryptionKey[2] & 0x0F);
   	TxPayloadData[6] = BinToChar(EncryptionKey[3] >> 4);
   	TxPayloadData[7] = BinToChar(EncryptionKey[3] & 0x0F);
   	TxPayloadData[8] = 0;
      
   	LCM_PutString8(TxPayloadData,4,4,DSP_NORMAL);
}
/********************************************************************
Function: KeeloqKey_Generation
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void KeeloqKey_Generation()
{
	
   	EncryptionKey[0] = MANUFACTURE[0];
	EncryptionKey[1] = MANUFACTURE[1];
	EncryptionKey[2] = MANUFACTURE[2];
	EncryptionKey[3] = MANUFACTURE[3];
	EncryptionKey[4] = MANUFACTURE[4];
	EncryptionKey[5] = MANUFACTURE[5];
	EncryptionKey[6] = MANUFACTURE[6];
	EncryptionKey[7] = MANUFACTURE[7];


	
	
	#if Hopping_type			
//if(Packet_type & 01)
// 	{				
	SN_A=0;
	SN_A |=(uint32) (0x0F & mRFData[1]) << 24;
	SN_A |=(uint32) mRFData[2] << 16;
	SN_A |=(uint32) mRFData[3] << 8;
	SN_A |=(uint32) mRFData[4] ;		
	KeeloqDecrypt(0x60000000 + SN_A);
	key_temp[0] = Ciphertext[0];
	key_temp[1] = Ciphertext[1];
	key_temp[2] = Ciphertext[2];
	key_temp[3] = Ciphertext[3];
	KeeloqDecrypt(0x20000000+ SN_A);	 
	EncryptionKey[0] = Ciphertext[0];
	EncryptionKey[1] = Ciphertext[1];
	EncryptionKey[2] = Ciphertext[2];
	EncryptionKey[3] = Ciphertext[3]; 
	EncryptionKey[4] = key_temp[0];
	EncryptionKey[5] = key_temp[1];
	EncryptionKey[6] = key_temp[2];
	EncryptionKey[7] = key_temp[3];  
// 	}	
	#endif
}
/********************************************************************
Function: GetEnDeKey
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void GetEnDeKey()
{
	if((mRFSNA[0]==(0x0F & mRFData[1]))&&(mRFSNA[1]==mRFData[2])
	&&(mRFSNA[2]==mRFData[3])&&(mRFSNA[3]==mRFData[4]))	
	{
		fLearnedA_R =1; 
		EncryptionKey[0] = EEPROM_RD(20);
		EncryptionKey[1] = EEPROM_RD(21);
		EncryptionKey[2] = EEPROM_RD(22);
		EncryptionKey[3] = EEPROM_RD(23); 
		EncryptionKey[4] = EEPROM_RD(24);
		EncryptionKey[5] = EEPROM_RD(25);
		EncryptionKey[6] = EEPROM_RD(26);
		EncryptionKey[7] = EEPROM_RD(27);   				
	}
	else if((mRFSNB[0]==(0x0F & mRFData[1]))&&(mRFSNB[1]==mRFData[2])
	&&(mRFSNB[2]==mRFData[3])&&(mRFSNB[3]==mRFData[4]))
	{
		fLearnedB_R =1; 
		EncryptionKey[0] = EEPROM_RD(30);
		EncryptionKey[1] = EEPROM_RD(31);
		EncryptionKey[2] = EEPROM_RD(32);
		EncryptionKey[3] = EEPROM_RD(33); 
		EncryptionKey[4] = EEPROM_RD(34);
		EncryptionKey[5] = EEPROM_RD(35);
		EncryptionKey[6] = EEPROM_RD(36);
		EncryptionKey[7] = EEPROM_RD(37); 
	}  	

}		            
/********************************************************************
Function: LCMdisplay_encryptedData
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void LCMdisplay_encryptedData()
{
	LCM_ConstString8(hoppingcode_3_En_Str,2,0,DSP_NORMAL);	
	LCM_ConstString8(hoppingcode_3_De_Str,3,0,DSP_NORMAL);			
	TxPayloadData[0] = BinToChar(mRFData[8] >> 4);
	TxPayloadData[1] = BinToChar(mRFData[8] & 0x0F);
	TxPayloadData[2] = BinToChar(mRFData[7] >> 4);
	TxPayloadData[3] = BinToChar(mRFData[7] & 0x0F);
	TxPayloadData[4] = BinToChar(mRFData[6] >> 4);
	TxPayloadData[5] = BinToChar(mRFData[6] & 0x0F);
	TxPayloadData[6] = BinToChar(mRFData[5] >> 4);
	TxPayloadData[7] = BinToChar(mRFData[5] & 0x0F);
	TxPayloadData[8] = 0;
	LCM_PutString8(TxPayloadData,2,8,DSP_NORMAL);			
}
/********************************************************************
Function: Save_TXA_SN_SC_KEY
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void Save_TXA_SN_SC_KEY()
{    
	//====SAVE SN	       
	mRFSNA[0]=(0x0F & mRFData[1]);
	EEPROM_WR(0,mRFSNA[0]);
	mRFSNA[1]=mRFData[2];
	EEPROM_WR(1,mRFSNA[1]);
	mRFSNA[2]=mRFData[3];
	EEPROM_WR(2,mRFSNA[2]);
	mRFSNA[3]=mRFData[4];
	EEPROM_WR(3,mRFSNA[3]);		
	mRFSNA[4]=(0x0F & mRFData[1])^mRFData[2]^mRFData[3]^mRFData[4];
	EEPROM_WR(4,mRFSNA[4]);        
	//====SAVE SC
	EEPROM_WR(10,Ciphertext[0]);
	EEPROM_WR(11,Ciphertext[1]);
	//====SAVE KEY
	EEPROM_WR(20,EncryptionKey[0]);
	EEPROM_WR(21,EncryptionKey[1]);
	EEPROM_WR(22,EncryptionKey[2]);
	EEPROM_WR(23,EncryptionKey[3]);		
	EEPROM_WR(24,EncryptionKey[4]);
	EEPROM_WR(25,EncryptionKey[5]);
	EEPROM_WR(26,EncryptionKey[6]);
	EEPROM_WR(27,EncryptionKey[7]);  
}
/********************************************************************
Function: Save_TXB_SN_SC_KEY
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void Save_TXB_SN_SC_KEY()
{   
	//====SAVE SN     
	mRFSNB[0]=(0x0F & mRFData[1]);
	EEPROM_WR(5,mRFSNB[0]);
	mRFSNB[1]=mRFData[2];
	EEPROM_WR(6,mRFSNB[1]);
	mRFSNB[2]=mRFData[3];
	EEPROM_WR(7,mRFSNB[2]);
	mRFSNB[3]=mRFData[4];
	EEPROM_WR(8,mRFSNB[3]);		
	mRFSNB[4]=(0x0F & mRFData[1])^mRFData[2]^mRFData[3]^mRFData[4];
	EEPROM_WR(9,mRFSNB[4]);
	//====SAVE SC
	EEPROM_WR(12,Ciphertext[0]);
	EEPROM_WR(13,Ciphertext[1]);		
	//====SAVE KEY
	EEPROM_WR(30,EncryptionKey[0]);
	EEPROM_WR(31,EncryptionKey[1]);
	EEPROM_WR(32,EncryptionKey[2]);
	EEPROM_WR(33,EncryptionKey[3]);		
	EEPROM_WR(34,EncryptionKey[4]);
	EEPROM_WR(35,EncryptionKey[5]);
	EEPROM_WR(36,EncryptionKey[6]);
	EEPROM_WR(37,EncryptionKey[7]);  
}
/********************************************************************
Function: Display_EnDecrypted_Key
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void Display_EnDecrypted_Key()
{
	LCM_ConstString8(hoppingcode_30_Str,2,0,DSP_NORMAL);	
	TxPayloadData[0] = BinToChar(EncryptionKey[7] >> 4);
	TxPayloadData[1] = BinToChar(EncryptionKey[7] & 0x0F);
	TxPayloadData[2] = BinToChar(EncryptionKey[6] >> 4);
	TxPayloadData[3] = BinToChar(EncryptionKey[6] & 0x0F);
	TxPayloadData[4] = BinToChar(EncryptionKey[5] >> 4);
	TxPayloadData[5] = BinToChar(EncryptionKey[5] & 0x0F);
	TxPayloadData[6] = BinToChar(EncryptionKey[4] >> 4);
	TxPayloadData[7] = BinToChar(EncryptionKey[3] & 0x0F);
	TxPayloadData[8] = 0;
	LCM_PutString8(TxPayloadData,3,0,DSP_NORMAL);
	
	TxPayloadData[0] = BinToChar(EncryptionKey[3] >> 4);
	TxPayloadData[1] = BinToChar(EncryptionKey[3] & 0x0F);
	TxPayloadData[2] = BinToChar(EncryptionKey[2] >> 4);
	TxPayloadData[3] = BinToChar(EncryptionKey[2] & 0x0F);
	TxPayloadData[4] = BinToChar(EncryptionKey[1] >> 4);
	TxPayloadData[5] = BinToChar(EncryptionKey[1] & 0x0F);
	TxPayloadData[6] = BinToChar(EncryptionKey[0] >> 4);
	TxPayloadData[7] = BinToChar(EncryptionKey[0] & 0x0F);
	TxPayloadData[8] = 0;
	LCM_PutString8(TxPayloadData,3,8,DSP_NORMAL);	
}
/********************************************************************
Function: Display_TXA_Info
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void Display_TXA_Info()
{
	uint8  i;
	//====dispaly SN 
	LCM_ConstString8(hoppingcode_51_Str,4,0,DSP_NORMAL);
	LCM_ConstString8(hoppingcode_52_Str,5,0,DSP_NORMAL);	
	LCM_ConstString8(hoppingcode_60_Str,6,0,DSP_NORMAL);                    			
	TxPayloadData[0] = BinToChar(mRFSNA[0] & 0x0F);
	TxPayloadData[1] = BinToChar(mRFData[2] >> 4);
	TxPayloadData[2] = BinToChar(mRFData[2] & 0x0F);
	TxPayloadData[3] = BinToChar(mRFData[3] >> 4);
	TxPayloadData[4] = BinToChar(mRFData[3] & 0x0F);
	TxPayloadData[5] = BinToChar(mRFData[4] >> 4);
	TxPayloadData[6] = BinToChar(mRFData[4] & 0x0F);
	TxPayloadData[7] = 0;   					             
	LCM_PutString8(TxPayloadData,4,3,DSP_NORMAL); 
                               
	//====dispaly SC
	for(i=5;i>0;)
	{
		i--;
		SyncConter10[i]=SyncCount_A_T%10;
		SyncCount_A_T/=10;
	}

	TxPayloadData[0] = BinToChar(SyncConter10[0]);
	TxPayloadData[1] = BinToChar(SyncConter10[1]);
	TxPayloadData[2] = BinToChar(SyncConter10[2]);
	TxPayloadData[3] = BinToChar(SyncConter10[3]);
	TxPayloadData[4] = BinToChar(SyncConter10[4]);
	TxPayloadData[5] = 0; 

	LCM_PutString8(TxPayloadData,5,3,DSP_NORMAL);									
					
	if((mRFData[0] & 0x02) ==0x02 )
		LCM_ConstString8(YesString,6,7,DSP_NORMAL);
	if((mRFData[0] & 0x01) ==0x01 )
		LCM_ConstString8(YesString,6,15,DSP_NORMAL);	
		
	LCM_ConstString8(hoppingcode_70_Str,7,0,DSP_NORMAL);		
}

/********************************************************************
Function: Display_TXA_Info
INPUT	:
OUTPUT	:
NOTE	:
********************************************************************/
void Display_TXB_Info()
{
	uint8  i;
	//====dispaly SN				
	LCM_ConstString8(hoppingcode_51_Str,4,0,DSP_NORMAL);
	LCM_ConstString8(hoppingcode_52_Str,5,0,DSP_NORMAL); 
	LCM_ConstString8(hoppingcode_60_Str,6,0,DSP_NORMAL);                		   
	TxPayloadData[0] = BinToChar(mRFSNB[0] & 0x0F);
	TxPayloadData[1] = BinToChar(mRFData[2] >> 4);
 	TxPayloadData[2] = BinToChar(mRFData[2] & 0x0F);
	TxPayloadData[3] = BinToChar(mRFData[3] >> 4);
	TxPayloadData[4] = BinToChar(mRFData[3] & 0x0F);
	TxPayloadData[5] = BinToChar(mRFData[4] >> 4);
	TxPayloadData[6] = BinToChar(mRFData[4] & 0x0F);
	TxPayloadData[7] = 0;    					            
	LCM_PutString8(TxPayloadData,4,3,DSP_NORMAL);
               
	//====dispaly SC
	for(i=5;i>0;)
	{
		i--;
		SyncConter10[i]=SyncCount_B_T%10;
		SyncCount_B_T/=10;
	}

	TxPayloadData[0] = BinToChar(SyncConter10[0]);
	TxPayloadData[1] = BinToChar(SyncConter10[1]);
	TxPayloadData[2] = BinToChar(SyncConter10[2]);
	TxPayloadData[3] = BinToChar(SyncConter10[3]);
	TxPayloadData[4] = BinToChar(SyncConter10[4]);
	TxPayloadData[5] = 0; 

	LCM_PutString8(TxPayloadData,5,3,DSP_NORMAL);	
   									
	if((mRFData[0] & 0x02) ==0x02 )
		LCM_ConstString8(YesString,6,7,DSP_NORMAL);					
	if((mRFData[0] & 0x01) ==0x01 )
		LCM_ConstString8(YesString,6,15,DSP_NORMAL);
		
	LCM_ConstString8(hoppingcode_71_Str,7,0,DSP_NORMAL);		
}	
//-----------------------------------
//Function: read data from EEPROM
//----------------------------------- 
unsigned char EEPROM_RD(unsigned char GU8V_EEPROM_ADDR)
{
	uint8 GU8V_RD_DATA;	
	_eeal=GU8V_EEPROM_ADDR;
	_mp1l=0x40;   	
//	_pbp=0x01;
    _mp1h= 0x01;
	_emi=0;
	_iar1|=0x02;
	_iar1|=0x01;
	while(_iar1&=0x01)
	{
		GCC_CLRWDT();	
	}
	GU8V_RD_DATA=_eed;
	_iar1=0x00;
//	_pbp &= 0b11111110;	
    _mp1h &= 0b11111110;
    _emi=1;
	return GU8V_RD_DATA;			
}            	

void EEPROM_WR(unsigned char GU8V_EEPROM_ADDR,unsigned char GU8V_WR_DATA)
{
	_eeal=GU8V_EEPROM_ADDR;
	_eed=GU8V_WR_DATA;
//	_pbp=0x01;
    _mp1h= 0x01;
	_mp1l=0x40;         //eec address
	_iar1|=0x08;
	_iar1|=0x04;
	while(_iar1&0x04)
	{
		GCC_CLRWDT();
	}					
	_iar1 = 0x00;
//	_pbp &= 0b11111110;
   _mp1h &= 0b11111110;
}


